﻿Class TextEditor

    'Ustawia lub pobiera tekst na pasku stanu.
    Public Property StatusText() As String
        Get
            Return sbiStatus.Content.ToString
        End Get
        Set(ByVal value As String)
            sbiStatus.Content = value
        End Set
    End Property

    'Pobieranie lub ustawianie edytowanego tekstu.
    Public Property EditText() As String
        Get
            Return txtEdit.Text
        End Get
        Set(ByVal value As String)
            txtEdit.Text = value
        End Set
    End Property

    'Czyszczenie zawartości pola txtEdit.
    Public Sub ClearEditBox()
        'Ustawianie właściwości EditText.
        EditText = String.Empty

        'Ustawianie oryginalnego koloru czcionki
        txtEdit.Foreground = Brushes.Black

        'Ustawianie tekstu paska stanu.
        StatusText = "Wyczyszczono zawartość pola tekstowego"
    End Sub

    Private Sub txtEdit_TextChanged(ByVal sender As Object, _
        ByVal e As System.Windows.Controls.TextChangedEventArgs) _
        Handles txtEdit.TextChanged

        'Ustawianie oryginalnego tekstu paska stanu.
        StatusText = "Gotowe"
    End Sub

    Private Sub tbrClear_Click(ByVal sender As Object, _
    ByVal e As System.Windows.RoutedEventArgs) _
    Handles tbrClear.Click

        'Czyszczenie zawartości pola tekstowego.
        ClearEditBox()
    End Sub

    Public Sub RedText()
        'Zmiana koloru tekstu na czerwony.
        txtEdit.Foreground = Brushes.Red

        'Aktualizacja tekstu na pasku stanu.
        StatusText = "Tekst ma kolor czerwony"
    End Sub

    Private Sub tbrRed_Click(ByVal sender As Object, _
        ByVal e As System.Windows.RoutedEventArgs) _
        Handles tbrRed.Click

        'Zmiana koloru tekstu na czerwony.
        RedText()
    End Sub

    Public Sub BlueText()
        'Zmiana koloru tekstu na niebieski.
        txtEdit.Foreground = Brushes.Blue

        'Aktualizacja tekstu paska stanu.
        StatusText = "Tekst ma kolor niebieski"
    End Sub

    Private Sub tbrBlue_Click(ByVal sender As Object, _
        ByVal e As System.Windows.RoutedEventArgs) _
        Handles tbrBlue.Click

        'Zmiana koloru tekstu na niebieski.
        BlueText()
    End Sub

    Public Sub UpperCaseText()
        'Zmienia litery na duże.
        EditText = EditText.ToUpper

        'Aktualizacja tekstu paska stanu.
        StatusText = "Wszystkie litery są duże"
    End Sub

    Private Sub tbrUpperCase_Click(ByVal sender As Object, _
        ByVal e As System.Windows.RoutedEventArgs) _
        Handles tbrUpperCase.Click

        'Zmiana liter na duże.
        UpperCaseText()
    End Sub

    Public Sub LowerCaseText()
        'Zmienia litery na małe.
        EditText = EditText.ToLower

        'Aktualizacja tekstu paska stanu.
        StatusText = "Wszystkie litery są małe"
    End Sub

    Private Sub tbrLowerCase_Click(ByVal sender As Object, _
        ByVal e As System.Windows.RoutedEventArgs) _
        Handles tbrLowerCase.Click

        'Zmiana liter na małe.
        LowerCaseText()
    End Sub

End Class
